IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_EST_PED_ELTR_DEMANDA_EM_ABERTO]'))
DROP VIEW [dbo].[V_EST_PED_ELTR_DEMANDA_EM_ABERTO]  
GO 
--SELECT * FROM V_EST_PED_ELTR_DEMANDA_EM_ABERTO WHERE CD_EMP =1 AND CD_FILIAL = 35 AND CD_PROD = 70838
CREATE VIEW V_EST_PED_ELTR_DEMANDA_EM_ABERTO AS
SELECT 
			E.CD_EMP,	
			E.CD_FIL_ENTR AS CD_FILIAL,	
			E.CD_FIL_ENTR AS CD_ORIG,
			E.CD_PED_SOL,
			E.DT_PED,
			10 AS TIPO,
			'DEMANDA DE COMPRAS EM ABERTO' AS TIPO_DEMANDA,
			E.CD_PROD,	 
			E.QT_IT - ISNULL(P.QT_PED,0) QT_SLD,
			E.CD_USU
		FROM 
			(SELECT 
				E.CD_EMP,
				E.CD_FIL_ENTR,
				I.CD_PROD,
				E.DT_PED,
				E.CD_PED_SOL,
				E.CD_USU,
				SUM(I.QT_IT_UN) QT_IT
			FROM         
				EST_PED_ELTR  E
				INNER JOIN EST_PED_ELTR_IT I ON 
				E.CD_EMP	 = I.CD_EMP AND 
				E.CD_PED_SOL = I.CD_PED_SOL 
			WHERE
				E.CD_EMP=1
				AND NOT E.STS_PED IN (3,4)
				AND E.FLAG_FECHAR = 0
				AND E.TP_REQ IN (0,1,3)
			GROUP BY 
				E.CD_EMP,
				E.CD_FIL_ENTR,
				I.CD_PROD,
				E.DT_PED,
				E.CD_PED_SOL,
				E.CD_USU) E
			LEFT JOIN (SELECT 
							EP.CD_EMP, 
							EP.CD_FIL_ENTR,
							EP.CD_PED_SOL,
							PD.CD_PROD,
							SUM( PD.QT_IT * PD.QT_EMB ) QT_PED
						FROM
							EST_PED_ELTR_FORN_PED_CP EP 
							INNER JOIN DBO.EST_PED_CP_IT PD ON 
							EP.CD_EMP		= PD.CD_EMP AND 
							EP.CD_FIL_ENTR	= PD.CD_FILIAL AND 
							EP.CD_PED		= PD.CD_PED 
	
							INNER JOIN EST_PED_CP_PENDENCIA PE ON
							PD.CD_EMP	 = PE.CD_EMP AND
							PD.CD_FILIAL = PE.CD_FILIAL AND
							PD.CD_PED	 = PE.CD_PED
						GROUP BY 
							EP.CD_EMP, 
							EP.CD_FIL_ENTR,
							PD.CD_PROD,
							EP.CD_PED_SOL) P ON 
			E.CD_EMP		= P.CD_EMP AND 
			E.CD_FIL_ENTR	= P.CD_FIL_ENTR AND
			E.CD_PROD		= P.CD_PROD and
			E.CD_PED_SOL = P.CD_PED_SOL
WHERE
	E.QT_IT - ISNULL(P.QT_PED,0) > 0 
